/*
*******************************************************************************
*
* File:		pxribeh.h
* Description:  Function declarations for requester initiator behavior
* Author: 	Henrik Liebau
* Created: 	05 Apr 2000, 09:24:05
* Modified:     Wed Jun  7 18:22:43 2000 by Henrik Liebau, BVS R&D
* Language:	C/C++ Include File
* Package:	PCI-X Protocol Permutator&Randomizer 
* Status: 	
*
* (C) Copyright 2000 by Agilent Technologies, All Rights Reserved.
*
*******************************************************************************
*/
 
#ifndef __pxribeh_H__
#define __pxribeh_H__

/* include type definitions, if not already done */
#ifndef __pxdef_H__
#include <pxdef.h>
#endif /* defined __pxdef_H__ */

/* include type definitions, if not already done */
#ifndef __pxbehdef_H__
#include <pxbehdef.h>
#endif /* defined __pxbehdef_H__ */

/* make sure this also runs in C++ programs */
#ifdef __cplusplus
extern "C" {
#endif

/*----------------------------------------------------------------------------*
 * BestXPprRIDefaultSet 
 * CLI abbrev.: pprridefaultset
 *
 * Set all settings concerning the requester initiator to default values 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprRIDefaultSet (	       /* @pprridefaultset */
  bx_handletype handle
  );

/*----------------------------------------------------------------------------*
 * BestXPprRIBehPermDefaultSet 
 * CLI abbrev.: pprribehpermdefaultset
 *
 * Set PPR Ri Behavior perm settings to defaults 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprRIBehPermDefaultSet (    /* @pprribehpermdefaultset */
  bx_handletype handle
  );

/*----------------------------------------------------------------------------*
 * BestXPprRIBehPermSet 
 * CLI abbrev.: pprribehpermset prop=<permprop> val = <value>
 *
 * Set PPR Behavior requester initiator settings 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprRIBehPermSet (	       /* @pprribehpermset */
  bx_handletype handle,
  bxppr_behpermtype permprop,			       /* @prop */
  bx_int32 value				       /* @val */
  );

/*----------------------------------------------------------------------------*
 * BestXPprRIBehPermGet 
 * CLI abbrev.: pprribehpermget prop=<permprop> val = <value>
 *
 * Get PPR Behavior requester initiator settings 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprRIBehPermGet (	       /* @pprribehpermget */
  bx_handletype handle,
  bxppr_behpermtype permprop,			       /* @prop */
  bx_int32 * pValue				       /* #RETURN "%08lx\\h" */
  );

/*----------------------------------------------------------------------------*
 * BestXPprRIBehListDefaultSet 
 * CLI abbrev.: pprribehlistdefaultset beh = <behavior>
 *
 * set variation list for requester initiator behaviors to default 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprRIBehListDefaultSet (    /* @pprribehlistdefaultset */
  bx_handletype handle,
  bx_ribehtype behavior				       /* @beh */
  );

/*----------------------------------------------------------------------------*
 * BestXPprRIBehListSet 
 * CLI abbrev.: pprribehlistset beh = <behavior> list = <list>
 *
 * set variation list for requester initiator behaviors 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprRIBehListSet (	       /* @pprribehlistset */
  bx_handletype handle,
  bx_ribehtype behavior,			       /* @beh */
  bxppr_listtype list				       /* @list */
  );

/*----------------------------------------------------------------------------*
 * BestXPprRIBehListGet 
 * CLI abbrev.: pprribehlistget beh = <behavior> list = <list>
 *
 * get variation list for requester initiator behaviors 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprRIBehListGet (	       /* @pprribehlistget */
  bx_handletype handle,
  bx_ribehtype behavior,			       /* @beh */
  bxppr_listtype * pList			       /* #RETURN "%s" */
  );

/*----------------------------------------------------------------------------*
 * BestXPprRIBehResultGet 
 * CLI abbrev.: pprribehresultget prop = <resultprop>
 *
 * get permutation result for selected resultprop parameter 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprRIBehResultGet (	       /* @pprribehresultget */
  bx_handletype handle,
  bxppr_behresulttype resultprop,		       /* @prop */
  bx_int32 * pValue				       /* #RETURN "%lu" */
 );

/*****************************************************************************
 * functions used internally
 *****************************************************************************/

#ifdef PPRX_EXPORTS

/*---------------------------------------------------------------------------*
 * bx_errtype PprRIBehProg ( bx_handletype handle,
 *
 * Purpose	: 
 *---------------------------------------------------------------------------*/
bx_errtype PprRIBehProg ( bx_handletype handle,
			  bxppr_vardatatype * varData,
			  bxppr_behresultdatatype * behResult );

/*---------------------------------------------------------------------------*
 * bx_errtype PprRIBehResultCompute ( bxppr_behresultdatatype * behResult )
 *
 * Purpose	: 
 *---------------------------------------------------------------------------*/
bx_errtype PprRIBehResultCompute ( bxppr_vardatatype * varData,
				   bxppr_behresultdatatype * behResult,
				   bxppr_propdatatype * blkProp );

#endif /* defined PPRX_EXPORTS */


#ifdef __cplusplus
}
#endif


#endif /* defined __pxribeh_H__ */
